/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.platform;

import com.google.common.base.Charsets;
import com.mojang.blaze3d.DontObfuscate;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.Util;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL14;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL20C;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GL32C;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

@DontObfuscate
public class GlStateManager {
    private static final boolean ON_LINUX = Util.getPlatform() == Util.OS.LINUX;
    public static final int TEXTURE_COUNT = 12;
    private static final BlendState BLEND = new BlendState();
    private static final DepthState DEPTH = new DepthState();
    private static final CullState CULL = new CullState();
    private static final PolygonOffsetState POLY_OFFSET = new PolygonOffsetState();
    private static final ColorLogicState COLOR_LOGIC = new ColorLogicState();
    private static final StencilState STENCIL = new StencilState();
    private static final ScissorState SCISSOR = new ScissorState();
    private static int activeTexture;
    private static final TextureState[] TEXTURES;
    private static final ColorMask COLOR_MASK;

    public static void _disableScissorTest() {
        RenderSystem.assertOnRenderThreadOrInit();
        GlStateManager.SCISSOR.mode.disable();
    }

    public static void _enableScissorTest() {
        RenderSystem.assertOnRenderThreadOrInit();
        GlStateManager.SCISSOR.mode.enable();
    }

    public static void _scissorBox(int p_84169_, int p_84170_, int p_84171_, int p_84172_) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL20.glScissor((int)p_84169_, (int)p_84170_, (int)p_84171_, (int)p_84172_);
    }

    public static void _disableDepthTest() {
        RenderSystem.assertOnRenderThreadOrInit();
        GlStateManager.DEPTH.mode.disable();
    }

    public static void _enableDepthTest() {
        RenderSystem.assertOnRenderThreadOrInit();
        GlStateManager.DEPTH.mode.enable();
    }

    public static void _depthFunc(int p_84324_) {
        RenderSystem.assertOnRenderThreadOrInit();
        if (p_84324_ != GlStateManager.DEPTH.func) {
            GlStateManager.DEPTH.func = p_84324_;
            GL11.glDepthFunc((int)p_84324_);
        }
    }

    public static void _depthMask(boolean p_84299_) {
        RenderSystem.assertOnRenderThread();
        if (p_84299_ != GlStateManager.DEPTH.mask) {
            GlStateManager.DEPTH.mask = p_84299_;
            GL11.glDepthMask((boolean)p_84299_);
        }
    }

    public static void _disableBlend() {
        RenderSystem.assertOnRenderThread();
        GlStateManager.BLEND.mode.disable();
    }

    public static void _enableBlend() {
        RenderSystem.assertOnRenderThread();
        GlStateManager.BLEND.mode.enable();
    }

    public static void _blendFunc(int p_84329_, int p_84330_) {
        RenderSystem.assertOnRenderThread();
        if (p_84329_ != GlStateManager.BLEND.srcRgb || p_84330_ != GlStateManager.BLEND.dstRgb) {
            GlStateManager.BLEND.srcRgb = p_84329_;
            GlStateManager.BLEND.dstRgb = p_84330_;
            GL11.glBlendFunc((int)p_84329_, (int)p_84330_);
        }
    }

    public static void _blendFuncSeparate(int p_84336_, int p_84337_, int p_84338_, int p_84339_) {
        RenderSystem.assertOnRenderThread();
        if (p_84336_ != GlStateManager.BLEND.srcRgb || p_84337_ != GlStateManager.BLEND.dstRgb || p_84338_ != GlStateManager.BLEND.srcAlpha || p_84339_ != GlStateManager.BLEND.dstAlpha) {
            GlStateManager.BLEND.srcRgb = p_84336_;
            GlStateManager.BLEND.dstRgb = p_84337_;
            GlStateManager.BLEND.srcAlpha = p_84338_;
            GlStateManager.BLEND.dstAlpha = p_84339_;
            GlStateManager.glBlendFuncSeparate(p_84336_, p_84337_, p_84338_, p_84339_);
        }
    }

    public static void _blendEquation(int p_84380_) {
        RenderSystem.assertOnRenderThread();
        GL14.glBlendEquation((int)p_84380_);
    }

    public static int glGetProgrami(int p_84382_, int p_84383_) {
        RenderSystem.assertOnRenderThread();
        return GL20.glGetProgrami((int)p_84382_, (int)p_84383_);
    }

    public static void glAttachShader(int p_84424_, int p_84425_) {
        RenderSystem.assertOnRenderThread();
        GL20.glAttachShader((int)p_84424_, (int)p_84425_);
    }

    public static void glDeleteShader(int p_84422_) {
        RenderSystem.assertOnRenderThread();
        GL20.glDeleteShader((int)p_84422_);
    }

    public static int glCreateShader(int p_84448_) {
        RenderSystem.assertOnRenderThread();
        return GL20.glCreateShader((int)p_84448_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glShaderSource(int p_157117_, List<String> p_157118_) {
        RenderSystem.assertOnRenderThread();
        StringBuilder $$2 = new StringBuilder();
        for (String $$3 : p_157118_) {
            $$2.append($$3);
        }
        byte[] $$4 = $$2.toString().getBytes(Charsets.UTF_8);
        ByteBuffer $$5 = MemoryUtil.memAlloc((int)($$4.length + 1));
        $$5.put($$4);
        $$5.put((byte)0);
        $$5.flip();
        try (MemoryStack $$6 = MemoryStack.stackPush();){
            PointerBuffer $$7 = $$6.mallocPointer(1);
            $$7.put($$5);
            GL20C.nglShaderSource((int)p_157117_, (int)1, (long)$$7.address0(), (long)0L);
        }
        finally {
            MemoryUtil.memFree((Buffer)$$5);
        }
    }

    public static void glCompileShader(int p_84466_) {
        RenderSystem.assertOnRenderThread();
        GL20.glCompileShader((int)p_84466_);
    }

    public static int glGetShaderi(int p_84450_, int p_84451_) {
        RenderSystem.assertOnRenderThread();
        return GL20.glGetShaderi((int)p_84450_, (int)p_84451_);
    }

    public static void _glUseProgram(int p_84479_) {
        RenderSystem.assertOnRenderThread();
        GL20.glUseProgram((int)p_84479_);
    }

    public static int glCreateProgram() {
        RenderSystem.assertOnRenderThread();
        return GL20.glCreateProgram();
    }

    public static void glDeleteProgram(int p_84485_) {
        RenderSystem.assertOnRenderThread();
        GL20.glDeleteProgram((int)p_84485_);
    }

    public static void glLinkProgram(int p_84491_) {
        RenderSystem.assertOnRenderThread();
        GL20.glLinkProgram((int)p_84491_);
    }

    public static int _glGetUniformLocation(int p_84346_, CharSequence p_84347_) {
        RenderSystem.assertOnRenderThread();
        return GL20.glGetUniformLocation((int)p_84346_, (CharSequence)p_84347_);
    }

    public static void _glUniform1(int p_84264_, IntBuffer p_84265_) {
        RenderSystem.assertOnRenderThread();
        GL20.glUniform1iv((int)p_84264_, (IntBuffer)p_84265_);
    }

    public static void _glUniform1i(int p_84468_, int p_84469_) {
        RenderSystem.assertOnRenderThread();
        GL20.glUniform1i((int)p_84468_, (int)p_84469_);
    }

    public static void _glUniform1(int p_84349_, FloatBuffer p_84350_) {
        RenderSystem.assertOnRenderThread();
        GL20.glUniform1fv((int)p_84349_, (FloatBuffer)p_84350_);
    }

    public static void _glUniform2(int p_84352_, IntBuffer p_84353_) {
        RenderSystem.assertOnRenderThread();
        GL20.glUniform2iv((int)p_84352_, (IntBuffer)p_84353_);
    }

    public static void _glUniform2(int p_84402_, FloatBuffer p_84403_) {
        RenderSystem.assertOnRenderThread();
        GL20.glUniform2fv((int)p_84402_, (FloatBuffer)p_84403_);
    }

    public static void _glUniform3(int p_84405_, IntBuffer p_84406_) {
        RenderSystem.assertOnRenderThread();
        GL20.glUniform3iv((int)p_84405_, (IntBuffer)p_84406_);
    }

    public static void _glUniform3(int p_84436_, FloatBuffer p_84437_) {
        RenderSystem.assertOnRenderThread();
        GL20.glUniform3fv((int)p_84436_, (FloatBuffer)p_84437_);
    }

    public static void _glUniform4(int p_84439_, IntBuffer p_84440_) {
        RenderSystem.assertOnRenderThread();
        GL20.glUniform4iv((int)p_84439_, (IntBuffer)p_84440_);
    }

    public static void _glUniform4(int p_84462_, FloatBuffer p_84463_) {
        RenderSystem.assertOnRenderThread();
        GL20.glUniform4fv((int)p_84462_, (FloatBuffer)p_84463_);
    }

    public static void _glUniformMatrix2(int p_84270_, boolean p_84271_, FloatBuffer p_84272_) {
        RenderSystem.assertOnRenderThread();
        GL20.glUniformMatrix2fv((int)p_84270_, (boolean)p_84271_, (FloatBuffer)p_84272_);
    }

    public static void _glUniformMatrix3(int p_84355_, boolean p_84356_, FloatBuffer p_84357_) {
        RenderSystem.assertOnRenderThread();
        GL20.glUniformMatrix3fv((int)p_84355_, (boolean)p_84356_, (FloatBuffer)p_84357_);
    }

    public static void _glUniformMatrix4(int p_84408_, boolean p_84409_, FloatBuffer p_84410_) {
        RenderSystem.assertOnRenderThread();
        GL20.glUniformMatrix4fv((int)p_84408_, (boolean)p_84409_, (FloatBuffer)p_84410_);
    }

    public static int _glGetAttribLocation(int p_84399_, CharSequence p_84400_) {
        RenderSystem.assertOnRenderThread();
        return GL20.glGetAttribLocation((int)p_84399_, (CharSequence)p_84400_);
    }

    public static void _glBindAttribLocation(int p_157062_, int p_157063_, CharSequence p_157064_) {
        RenderSystem.assertOnRenderThread();
        GL20.glBindAttribLocation((int)p_157062_, (int)p_157063_, (CharSequence)p_157064_);
    }

    public static int _glGenBuffers() {
        RenderSystem.assertOnRenderThreadOrInit();
        return GL15.glGenBuffers();
    }

    public static int _glGenVertexArrays() {
        RenderSystem.assertOnRenderThreadOrInit();
        return GL30.glGenVertexArrays();
    }

    public static void _glBindBuffer(int p_84481_, int p_84482_) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL15.glBindBuffer((int)p_84481_, (int)p_84482_);
    }

    public static void _glBindVertexArray(int p_157069_) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL30.glBindVertexArray((int)p_157069_);
    }

    public static void _glBufferData(int p_84257_, ByteBuffer p_84258_, int p_84259_) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL15.glBufferData((int)p_84257_, (ByteBuffer)p_84258_, (int)p_84259_);
    }

    public static void _glBufferData(int p_157071_, long p_157072_, int p_157073_) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL15.glBufferData((int)p_157071_, (long)p_157072_, (int)p_157073_);
    }

    @Nullable
    public static ByteBuffer _glMapBuffer(int p_157091_, int p_157092_) {
        RenderSystem.assertOnRenderThreadOrInit();
        return GL15.glMapBuffer((int)p_157091_, (int)p_157092_);
    }

    public static void _glUnmapBuffer(int p_157099_) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL15.glUnmapBuffer((int)p_157099_);
    }

    public static void _glDeleteBuffers(int p_84497_) {
        RenderSystem.assertOnRenderThread();
        if (ON_LINUX) {
            GL32C.glBindBuffer((int)34962, (int)p_84497_);
            GL32C.glBufferData((int)34962, (long)0L, (int)35048);
            GL32C.glBindBuffer((int)34962, (int)0);
        }
        GL15.glDeleteBuffers((int)p_84497_);
    }

    public static void _glCopyTexSubImage2D(int p_84180_, int p_84181_, int p_84182_, int p_84183_, int p_84184_, int p_84185_, int p_84186_, int p_84187_) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL20.glCopyTexSubImage2D((int)p_84180_, (int)p_84181_, (int)p_84182_, (int)p_84183_, (int)p_84184_, (int)p_84185_, (int)p_84186_, (int)p_84187_);
    }

    public static void _glDeleteVertexArrays(int p_157077_) {
        RenderSystem.assertOnRenderThread();
        GL30.glDeleteVertexArrays((int)p_157077_);
    }

    public static void _glBindFramebuffer(int p_84487_, int p_84488_) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL30.glBindFramebuffer((int)p_84487_, (int)p_84488_);
    }

    public static void _glBlitFrameBuffer(int p_84189_, int p_84190_, int p_84191_, int p_84192_, int p_84193_, int p_84194_, int p_84195_, int p_84196_, int p_84197_, int p_84198_) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL30.glBlitFramebuffer((int)p_84189_, (int)p_84190_, (int)p_84191_, (int)p_84192_, (int)p_84193_, (int)p_84194_, (int)p_84195_, (int)p_84196_, (int)p_84197_, (int)p_84198_);
    }

    public static void _glBindRenderbuffer(int p_157066_, int p_157067_) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL30.glBindRenderbuffer((int)p_157066_, (int)p_157067_);
    }

    public static void _glDeleteRenderbuffers(int p_157075_) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL30.glDeleteRenderbuffers((int)p_157075_);
    }

    public static void _glDeleteFramebuffers(int p_84503_) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL30.glDeleteFramebuffers((int)p_84503_);
    }

    public static int glGenFramebuffers() {
        RenderSystem.assertOnRenderThreadOrInit();
        return GL30.glGenFramebuffers();
    }

    public static int glGenRenderbuffers() {
        RenderSystem.assertOnRenderThreadOrInit();
        return GL30.glGenRenderbuffers();
    }

    public static void _glRenderbufferStorage(int p_157094_, int p_157095_, int p_157096_, int p_157097_) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL30.glRenderbufferStorage((int)p_157094_, (int)p_157095_, (int)p_157096_, (int)p_157097_);
    }

    public static void _glFramebufferRenderbuffer(int p_157085_, int p_157086_, int p_157087_, int p_157088_) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL30.glFramebufferRenderbuffer((int)p_157085_, (int)p_157086_, (int)p_157087_, (int)p_157088_);
    }

    public static int glCheckFramebufferStatus(int p_84509_) {
        RenderSystem.assertOnRenderThreadOrInit();
        return GL30.glCheckFramebufferStatus((int)p_84509_);
    }

    public static void _glFramebufferTexture2D(int p_84174_, int p_84175_, int p_84176_, int p_84177_, int p_84178_) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL30.glFramebufferTexture2D((int)p_84174_, (int)p_84175_, (int)p_84176_, (int)p_84177_, (int)p_84178_);
    }

    public static int getBoundFramebuffer() {
        RenderSystem.assertOnRenderThread();
        return GlStateManager._getInteger(36006);
    }

    public static void glActiveTexture(int p_84515_) {
        RenderSystem.assertOnRenderThread();
        GL13.glActiveTexture((int)p_84515_);
    }

    public static void glBlendFuncSeparate(int p_84389_, int p_84390_, int p_84391_, int p_84392_) {
        RenderSystem.assertOnRenderThread();
        GL14.glBlendFuncSeparate((int)p_84389_, (int)p_84390_, (int)p_84391_, (int)p_84392_);
    }

    public static String glGetShaderInfoLog(int p_84493_, int p_84494_) {
        RenderSystem.assertOnRenderThread();
        return GL20.glGetShaderInfoLog((int)p_84493_, (int)p_84494_);
    }

    public static String glGetProgramInfoLog(int p_84499_, int p_84500_) {
        RenderSystem.assertOnRenderThread();
        return GL20.glGetProgramInfoLog((int)p_84499_, (int)p_84500_);
    }

    public static void setupLevelDiffuseLighting(Vector3f p_254343_, Vector3f p_254532_, Matrix4f p_254339_) {
        RenderSystem.assertOnRenderThread();
        RenderSystem.setShaderLights(p_254339_.transformDirection((Vector3fc)p_254343_, new Vector3f()), p_254339_.transformDirection((Vector3fc)p_254532_, new Vector3f()));
    }

    public static void setupGuiFlatDiffuseLighting(Vector3f p_254237_, Vector3f p_253658_) {
        RenderSystem.assertOnRenderThread();
        Matrix4f $$2 = new Matrix4f().rotationY(-0.3926991f).rotateX(2.3561945f);
        GlStateManager.setupLevelDiffuseLighting(p_254237_, p_253658_, $$2);
    }

    public static void setupGui3DDiffuseLighting(Vector3f p_254290_, Vector3f p_254528_) {
        RenderSystem.assertOnRenderThread();
        Matrix4f $$2 = new Matrix4f().scaling(1.0f, -1.0f, 1.0f).rotateYXZ(1.0821041f, 3.2375858f, 0.0f).rotateYXZ(-0.3926991f, 2.3561945f, 0.0f);
        GlStateManager.setupLevelDiffuseLighting(p_254290_, p_254528_, $$2);
    }

    public static void _enableCull() {
        RenderSystem.assertOnRenderThread();
        GlStateManager.CULL.enable.enable();
    }

    public static void _disableCull() {
        RenderSystem.assertOnRenderThread();
        GlStateManager.CULL.enable.disable();
    }

    public static void _polygonMode(int p_84517_, int p_84518_) {
        RenderSystem.assertOnRenderThread();
        GL11.glPolygonMode((int)p_84517_, (int)p_84518_);
    }

    public static void _enablePolygonOffset() {
        RenderSystem.assertOnRenderThread();
        GlStateManager.POLY_OFFSET.fill.enable();
    }

    public static void _disablePolygonOffset() {
        RenderSystem.assertOnRenderThread();
        GlStateManager.POLY_OFFSET.fill.disable();
    }

    public static void _polygonOffset(float p_84137_, float p_84138_) {
        RenderSystem.assertOnRenderThread();
        if (p_84137_ != GlStateManager.POLY_OFFSET.factor || p_84138_ != GlStateManager.POLY_OFFSET.units) {
            GlStateManager.POLY_OFFSET.factor = p_84137_;
            GlStateManager.POLY_OFFSET.units = p_84138_;
            GL11.glPolygonOffset((float)p_84137_, (float)p_84138_);
        }
    }

    public static void _enableColorLogicOp() {
        RenderSystem.assertOnRenderThread();
        GlStateManager.COLOR_LOGIC.enable.enable();
    }

    public static void _disableColorLogicOp() {
        RenderSystem.assertOnRenderThread();
        GlStateManager.COLOR_LOGIC.enable.disable();
    }

    public static void _logicOp(int p_84533_) {
        RenderSystem.assertOnRenderThread();
        if (p_84533_ != GlStateManager.COLOR_LOGIC.op) {
            GlStateManager.COLOR_LOGIC.op = p_84533_;
            GL11.glLogicOp((int)p_84533_);
        }
    }

    public static void _activeTexture(int p_84539_) {
        RenderSystem.assertOnRenderThread();
        if (activeTexture != p_84539_ - 33984) {
            activeTexture = p_84539_ - 33984;
            GlStateManager.glActiveTexture(p_84539_);
        }
    }

    public static void _texParameter(int p_84161_, int p_84162_, float p_84163_) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL11.glTexParameterf((int)p_84161_, (int)p_84162_, (float)p_84163_);
    }

    public static void _texParameter(int p_84332_, int p_84333_, int p_84334_) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL11.glTexParameteri((int)p_84332_, (int)p_84333_, (int)p_84334_);
    }

    public static int _getTexLevelParameter(int p_84385_, int p_84386_, int p_84387_) {
        return GL11.glGetTexLevelParameteri((int)p_84385_, (int)p_84386_, (int)p_84387_);
    }

    public static int _genTexture() {
        RenderSystem.assertOnRenderThreadOrInit();
        return GL11.glGenTextures();
    }

    public static void _genTextures(int[] p_84306_) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL11.glGenTextures((int[])p_84306_);
    }

    public static void _deleteTexture(int p_84542_) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL11.glDeleteTextures((int)p_84542_);
        for (TextureState $$1 : TEXTURES) {
            if ($$1.binding != p_84542_) continue;
            $$1.binding = -1;
        }
    }

    public static void _deleteTextures(int[] p_84366_) {
        RenderSystem.assertOnRenderThreadOrInit();
        for (TextureState $$1 : TEXTURES) {
            for (int $$2 : p_84366_) {
                if ($$1.binding != $$2) continue;
                $$1.binding = -1;
            }
        }
        GL11.glDeleteTextures((int[])p_84366_);
    }

    public static void _bindTexture(int p_84545_) {
        RenderSystem.assertOnRenderThreadOrInit();
        if (p_84545_ != GlStateManager.TEXTURES[GlStateManager.activeTexture].binding) {
            GlStateManager.TEXTURES[GlStateManager.activeTexture].binding = p_84545_;
            GL11.glBindTexture((int)3553, (int)p_84545_);
        }
    }

    public static int _getActiveTexture() {
        return activeTexture + 33984;
    }

    public static void _texImage2D(int p_84210_, int p_84211_, int p_84212_, int p_84213_, int p_84214_, int p_84215_, int p_84216_, int p_84217_, @Nullable IntBuffer p_84218_) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL11.glTexImage2D((int)p_84210_, (int)p_84211_, (int)p_84212_, (int)p_84213_, (int)p_84214_, (int)p_84215_, (int)p_84216_, (int)p_84217_, (IntBuffer)p_84218_);
    }

    public static void _texSubImage2D(int p_84200_, int p_84201_, int p_84202_, int p_84203_, int p_84204_, int p_84205_, int p_84206_, int p_84207_, long p_84208_) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL11.glTexSubImage2D((int)p_84200_, (int)p_84201_, (int)p_84202_, (int)p_84203_, (int)p_84204_, (int)p_84205_, (int)p_84206_, (int)p_84207_, (long)p_84208_);
    }

    public static void upload(int p_287776_, int p_287602_, int p_287633_, int p_287778_, int p_287752_, NativeImage.Format p_287608_, IntBuffer p_287753_, Consumer<IntBuffer> p_287739_) {
        if (!RenderSystem.isOnRenderThreadOrInit()) {
            RenderSystem.recordRenderCall(() -> GlStateManager._upload(p_287776_, p_287602_, p_287633_, p_287778_, p_287752_, p_287608_, p_287753_, p_287739_));
        } else {
            GlStateManager._upload(p_287776_, p_287602_, p_287633_, p_287778_, p_287752_, p_287608_, p_287753_, p_287739_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _upload(int p_287672_, int p_287577_, int p_287618_, int p_287777_, int p_287707_, NativeImage.Format p_287692_, IntBuffer p_287674_, Consumer<IntBuffer> p_287588_) {
        try {
            RenderSystem.assertOnRenderThreadOrInit();
            GlStateManager._pixelStore(3314, p_287777_);
            GlStateManager._pixelStore(3316, 0);
            GlStateManager._pixelStore(3315, 0);
            p_287692_.setUnpackPixelStoreState();
            GL11.glTexSubImage2D((int)3553, (int)p_287672_, (int)p_287577_, (int)p_287618_, (int)p_287777_, (int)p_287707_, (int)p_287692_.glFormat(), (int)5121, (IntBuffer)p_287674_);
        }
        finally {
            p_287588_.accept(p_287674_);
        }
    }

    public static void _getTexImage(int p_84228_, int p_84229_, int p_84230_, int p_84231_, long p_84232_) {
        RenderSystem.assertOnRenderThread();
        GL11.glGetTexImage((int)p_84228_, (int)p_84229_, (int)p_84230_, (int)p_84231_, (long)p_84232_);
    }

    public static void _viewport(int p_84431_, int p_84432_, int p_84433_, int p_84434_) {
        RenderSystem.assertOnRenderThreadOrInit();
        Viewport.INSTANCE.x = p_84431_;
        Viewport.INSTANCE.y = p_84432_;
        Viewport.INSTANCE.width = p_84433_;
        Viewport.INSTANCE.height = p_84434_;
        GL11.glViewport((int)p_84431_, (int)p_84432_, (int)p_84433_, (int)p_84434_);
    }

    public static void _colorMask(boolean p_84301_, boolean p_84302_, boolean p_84303_, boolean p_84304_) {
        RenderSystem.assertOnRenderThread();
        if (p_84301_ != GlStateManager.COLOR_MASK.red || p_84302_ != GlStateManager.COLOR_MASK.green || p_84303_ != GlStateManager.COLOR_MASK.blue || p_84304_ != GlStateManager.COLOR_MASK.alpha) {
            GlStateManager.COLOR_MASK.red = p_84301_;
            GlStateManager.COLOR_MASK.green = p_84302_;
            GlStateManager.COLOR_MASK.blue = p_84303_;
            GlStateManager.COLOR_MASK.alpha = p_84304_;
            GL11.glColorMask((boolean)p_84301_, (boolean)p_84302_, (boolean)p_84303_, (boolean)p_84304_);
        }
    }

    public static void _stencilFunc(int p_84427_, int p_84428_, int p_84429_) {
        RenderSystem.assertOnRenderThread();
        if (p_84427_ != GlStateManager.STENCIL.func.func || p_84427_ != GlStateManager.STENCIL.func.ref || p_84427_ != GlStateManager.STENCIL.func.mask) {
            GlStateManager.STENCIL.func.func = p_84427_;
            GlStateManager.STENCIL.func.ref = p_84428_;
            GlStateManager.STENCIL.func.mask = p_84429_;
            GL11.glStencilFunc((int)p_84427_, (int)p_84428_, (int)p_84429_);
        }
    }

    public static void _stencilMask(int p_84551_) {
        RenderSystem.assertOnRenderThread();
        if (p_84551_ != GlStateManager.STENCIL.mask) {
            GlStateManager.STENCIL.mask = p_84551_;
            GL11.glStencilMask((int)p_84551_);
        }
    }

    public static void _stencilOp(int p_84453_, int p_84454_, int p_84455_) {
        RenderSystem.assertOnRenderThread();
        if (p_84453_ != GlStateManager.STENCIL.fail || p_84454_ != GlStateManager.STENCIL.zfail || p_84455_ != GlStateManager.STENCIL.zpass) {
            GlStateManager.STENCIL.fail = p_84453_;
            GlStateManager.STENCIL.zfail = p_84454_;
            GlStateManager.STENCIL.zpass = p_84455_;
            GL11.glStencilOp((int)p_84453_, (int)p_84454_, (int)p_84455_);
        }
    }

    public static void _clearDepth(double p_84122_) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL11.glClearDepth((double)p_84122_);
    }

    public static void _clearColor(float p_84319_, float p_84320_, float p_84321_, float p_84322_) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL11.glClearColor((float)p_84319_, (float)p_84320_, (float)p_84321_, (float)p_84322_);
    }

    public static void _clearStencil(int p_84554_) {
        RenderSystem.assertOnRenderThread();
        GL11.glClearStencil((int)p_84554_);
    }

    public static void _clear(int p_84267_, boolean p_84268_) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL11.glClear((int)p_84267_);
        if (p_84268_) {
            GlStateManager._getError();
        }
    }

    public static void _glDrawPixels(int p_157079_, int p_157080_, int p_157081_, int p_157082_, long p_157083_) {
        RenderSystem.assertOnRenderThread();
        GL11.glDrawPixels((int)p_157079_, (int)p_157080_, (int)p_157081_, (int)p_157082_, (long)p_157083_);
    }

    public static void _vertexAttribPointer(int p_84239_, int p_84240_, int p_84241_, boolean p_84242_, int p_84243_, long p_84244_) {
        RenderSystem.assertOnRenderThread();
        GL20.glVertexAttribPointer((int)p_84239_, (int)p_84240_, (int)p_84241_, (boolean)p_84242_, (int)p_84243_, (long)p_84244_);
    }

    public static void _vertexAttribIPointer(int p_157109_, int p_157110_, int p_157111_, int p_157112_, long p_157113_) {
        RenderSystem.assertOnRenderThread();
        GL30.glVertexAttribIPointer((int)p_157109_, (int)p_157110_, (int)p_157111_, (int)p_157112_, (long)p_157113_);
    }

    public static void _enableVertexAttribArray(int p_84566_) {
        RenderSystem.assertOnRenderThread();
        GL20.glEnableVertexAttribArray((int)p_84566_);
    }

    public static void _disableVertexAttribArray(int p_84087_) {
        RenderSystem.assertOnRenderThread();
        GL20.glDisableVertexAttribArray((int)p_84087_);
    }

    public static void _drawElements(int p_157054_, int p_157055_, int p_157056_, long p_157057_) {
        RenderSystem.assertOnRenderThread();
        GL11.glDrawElements((int)p_157054_, (int)p_157055_, (int)p_157056_, (long)p_157057_);
    }

    public static void _pixelStore(int p_84523_, int p_84524_) {
        RenderSystem.assertOnRenderThreadOrInit();
        GL11.glPixelStorei((int)p_84523_, (int)p_84524_);
    }

    public static void _readPixels(int p_84220_, int p_84221_, int p_84222_, int p_84223_, int p_84224_, int p_84225_, ByteBuffer p_84226_) {
        RenderSystem.assertOnRenderThread();
        GL11.glReadPixels((int)p_84220_, (int)p_84221_, (int)p_84222_, (int)p_84223_, (int)p_84224_, (int)p_84225_, (ByteBuffer)p_84226_);
    }

    public static void _readPixels(int p_157101_, int p_157102_, int p_157103_, int p_157104_, int p_157105_, int p_157106_, long p_157107_) {
        RenderSystem.assertOnRenderThread();
        GL11.glReadPixels((int)p_157101_, (int)p_157102_, (int)p_157103_, (int)p_157104_, (int)p_157105_, (int)p_157106_, (long)p_157107_);
    }

    public static int _getError() {
        RenderSystem.assertOnRenderThread();
        return GL11.glGetError();
    }

    public static String _getString(int p_84090_) {
        RenderSystem.assertOnRenderThread();
        return GL11.glGetString((int)p_84090_);
    }

    public static int _getInteger(int p_84093_) {
        RenderSystem.assertOnRenderThreadOrInit();
        return GL11.glGetInteger((int)p_84093_);
    }

    static {
        TEXTURES = (TextureState[])IntStream.range(0, 12).mapToObj(p_157120_ -> new TextureState()).toArray(TextureState[]::new);
        COLOR_MASK = new ColorMask();
    }

    static class ScissorState {
        public final BooleanState mode = new BooleanState(3089);

        ScissorState() {
        }
    }

    static class BooleanState {
        private final int state;
        private boolean enabled;

        public BooleanState(int p_84588_) {
            this.state = p_84588_;
        }

        public void disable() {
            this.setEnabled(false);
        }

        public void enable() {
            this.setEnabled(true);
        }

        public void setEnabled(boolean p_84591_) {
            RenderSystem.assertOnRenderThreadOrInit();
            if (p_84591_ != this.enabled) {
                this.enabled = p_84591_;
                if (p_84591_) {
                    GL11.glEnable((int)this.state);
                } else {
                    GL11.glDisable((int)this.state);
                }
            }
        }
    }

    static class DepthState {
        public final BooleanState mode = new BooleanState(2929);
        public boolean mask = true;
        public int func = 513;

        DepthState() {
        }
    }

    static class BlendState {
        public final BooleanState mode = new BooleanState(3042);
        public int srcRgb = 1;
        public int dstRgb = 0;
        public int srcAlpha = 1;
        public int dstAlpha = 0;

        BlendState() {
        }
    }

    static class CullState {
        public final BooleanState enable = new BooleanState(2884);
        public int mode = 1029;

        CullState() {
        }
    }

    static class PolygonOffsetState {
        public final BooleanState fill = new BooleanState(32823);
        public final BooleanState line = new BooleanState(10754);
        public float factor;
        public float units;

        PolygonOffsetState() {
        }
    }

    static class ColorLogicState {
        public final BooleanState enable = new BooleanState(3058);
        public int op = 5379;

        ColorLogicState() {
        }
    }

    static class TextureState {
        public int binding;

        TextureState() {
        }
    }

    public static enum Viewport {
        INSTANCE;

        protected int x;
        protected int y;
        protected int width;
        protected int height;

        public static int x() {
            return Viewport.INSTANCE.x;
        }

        public static int y() {
            return Viewport.INSTANCE.y;
        }

        public static int width() {
            return Viewport.INSTANCE.width;
        }

        public static int height() {
            return Viewport.INSTANCE.height;
        }
    }

    static class ColorMask {
        public boolean red = true;
        public boolean green = true;
        public boolean blue = true;
        public boolean alpha = true;

        ColorMask() {
        }
    }

    static class StencilState {
        public final StencilFunc func = new StencilFunc();
        public int mask = -1;
        public int fail = 7680;
        public int zfail = 7680;
        public int zpass = 7680;

        StencilState() {
        }
    }

    static class StencilFunc {
        public int func = 519;
        public int ref;
        public int mask = -1;

        StencilFunc() {
        }
    }

    @DontObfuscate
    public static enum DestFactor {
        CONSTANT_ALPHA(32771),
        CONSTANT_COLOR(32769),
        DST_ALPHA(772),
        DST_COLOR(774),
        ONE(1),
        ONE_MINUS_CONSTANT_ALPHA(32772),
        ONE_MINUS_CONSTANT_COLOR(32770),
        ONE_MINUS_DST_ALPHA(773),
        ONE_MINUS_DST_COLOR(775),
        ONE_MINUS_SRC_ALPHA(771),
        ONE_MINUS_SRC_COLOR(769),
        SRC_ALPHA(770),
        SRC_COLOR(768),
        ZERO(0);

        public final int value;

        private DestFactor(int p_84652_) {
            this.value = p_84652_;
        }
    }

    @DontObfuscate
    public static enum SourceFactor {
        CONSTANT_ALPHA(32771),
        CONSTANT_COLOR(32769),
        DST_ALPHA(772),
        DST_COLOR(774),
        ONE(1),
        ONE_MINUS_CONSTANT_ALPHA(32772),
        ONE_MINUS_CONSTANT_COLOR(32770),
        ONE_MINUS_DST_ALPHA(773),
        ONE_MINUS_DST_COLOR(775),
        ONE_MINUS_SRC_ALPHA(771),
        ONE_MINUS_SRC_COLOR(769),
        SRC_ALPHA(770),
        SRC_ALPHA_SATURATE(776),
        SRC_COLOR(768),
        ZERO(0);

        public final int value;

        private SourceFactor(int p_84757_) {
            this.value = p_84757_;
        }
    }

    public static enum LogicOp {
        AND(5377),
        AND_INVERTED(5380),
        AND_REVERSE(5378),
        CLEAR(5376),
        COPY(5379),
        COPY_INVERTED(5388),
        EQUIV(5385),
        INVERT(5386),
        NAND(5390),
        NOOP(5381),
        NOR(5384),
        OR(5383),
        OR_INVERTED(5389),
        OR_REVERSE(5387),
        SET(5391),
        XOR(5382);

        public final int value;

        private LogicOp(int p_84721_) {
            this.value = p_84721_;
        }
    }
}

